function replaceSVG(target) 
{
    $=jQuery;

    $('.' + target).each(function(index){
		var $img = $(this).find('img');
		
		$($img).each(function(index){
			var imgURL = $(this).attr('src');
			var $current_img = $(this);
    
			$.get(imgURL, function(data) {
		
				// Get the SVG tag, ignore the rest
				var $svg = $(data).find('svg');
		
				var svgID = $svg.attr('id', 'svg-icon-replaced-'+index);
		
				// Add replaced image's classes to the new SVG
					$svg = $svg.attr('class', 'svg-icon-replaced');
		
				// Remove any invalid XML tags as per http://validator.w3.org
				$svg = $svg.removeAttr('xmlns:a');
		
				// Replace image with new SVG
				$current_img.replaceWith($svg);
		
			}, 'xml');
		});
    });

}

function blog1_functions()
{
	$=jQuery;
	if ($('.blog1').length)
	{
		if($('.blog1 .et_pb_post .post_meta_after').length < 1)
		{
			$('.blog1 .et_pb_post').each(function(){
				var $categories = $(this).find('.post-meta a[rel*="category"], .post-meta a[rel*="tag"]');
				var $date = $(this).find('.published');
				var $read_more = $(this).find('.more-link');
				( $(this).find('.et_pb_image_container').length ) ? $(this).find('.et_pb_image_container').after('<span class="categories"></span>') : $(this).find('.entry-title').before('<span class="categories"></span>');
				$(this).find('.post-content').after('<span class="post_meta_after"></span>');
				$(this).find('.categories').append($categories);
				$(this).find('.post_meta_after').append($date,$read_more);
				var $post_meta_no_pipes = ( $(this).find('.post-meta').length ) ? $(this).find('.post-meta').html().replace(/(\s\|\s)/gi,'').replace(/,/gi,'') : '';
				$(this).find('.post-meta').html($post_meta_no_pipes);
			});
		}
	}

}

function blog2_functions()
{
	$=jQuery;
	if($('.blog2').length)
	{
		if($('.blog2 .et_pb_post .custom_meta').length < 1)
		{
			$('.blog2').each(function(){
				var $meta_color = $(this).find('.post-meta a').css('color');
				var $meta_fontSize = $(this).find('.post-meta a').css('font-size');
				var $meta_letterSpacing = $(this).find('.post-meta a').css('letter-spacing');
				var $meta_textTransform = $(this).find('.post-meta a').css('text-transform');
				$(this).before('<style>.blog2 .custom_meta a, .blog2 .custom_meta .published {color: '+ $meta_color +'!important; font-size: '+ $meta_fontSize +'!important; letter-spacing: '+ $meta_letterSpacing +'!important; text-transform: '+ $meta_textTransform +'!important;}</style>');	
			});

			$('.blog2 .et_pb_post').each(function(){
				var $img_link = $(this).find('.entry-featured-image-url img').attr('src');	var $img_link = $(this).find('.entry-featured-image-url img').attr('src');
				var $categories = $(this).find('.post-meta a[rel*="category"], .post-meta a[rel*="tag"]');
				var $date = $(this).find('.published');
				$(this).find('.et_pb_image_container').remove();
				$(this).css('background','url('+ $img_link +') center/cover no-repeat');
				$(this).find('.entry-title').before('<div class="custom_meta"><span class="categories"></span><span class="date"></span></div>');
				$(this).find('.categories').append($categories);
				$(this).find('.date').append($date);
				var $post_meta_no_pipes = ( $(this).find('.post-meta').length ) ? $(this).find('.post-meta').html().replace(/(\s\|\s)/gi,'').replace(/,/gi,'') : '';
				var $read_more_link = $(this).find('.post-content .more-link');
				$(this).find('.post-meta').html($post_meta_no_pipes).after($read_more_link);
				$(this).find('.post-content').remove();
			});
		}
	}
}

function blog3_functions()
{
	$=jQuery;
	if($('.blog3').length)
	{
		if ($('.blog3 .custom_meta').length < 1)
		{
			$('.blog3').each(function(){
				var $meta_color = $(this).find('.post-meta a').css('color');
				var $meta_fontSize = $(this).find('.post-meta a').css('font-size');
				var $meta_letterSpacing = $(this).find('.post-meta a').css('letter-spacing');
				var $meta_textTransform = $(this).find('.post-meta a').css('text-transform');
				$(this).before('<style>.blog3 .custom_meta a, .blog3 .custom_meta .published {color: '+ $meta_color +'!important; font-size: '+ $meta_fontSize +'!important; letter-spacing: '+ $meta_letterSpacing +'!important; text-transform: '+ $meta_textTransform +'!important;}</style>');
			});

			$('.blog3 .et_pb_post').each(function(){
				var $img_link = $(this).find('.entry-featured-image-url img').attr('src');
				var $post_title = $(this).find('.entry-title');
				var $post_meta = $(this).find('.post-meta');
				var $categories = $(this).find('.post-meta a[rel*="category"], .post-meta a[rel*="tag"]');
				var $date = $(this).find('.published');
				var $post_content = $(this).find('.post-content');
				$(this).find('.entry-featured-image-url img').remove();
				$(this).find('.entry-featured-image-url').css('background','url('+ $img_link +') center/cover no-repeat');
				$(this).append('<div class="post_contents"><div class="custom_meta"><span class="categories"></span><span class="date"></span></div></div>');
				$(this).find('.post_contents').append($post_title, $post_meta, $post_content);
				$(this).find('.categories').append($categories);
				$(this).find('.date').append($date);
				var $post_meta_no_pipes = ( $(this).find('.post-meta').length ) ? $(this).find('.post-meta').html().replace(/(\s\|\s)/gi,'').replace(/,/gi,'') : '';
				$(this).find('.post-meta').html($post_meta_no_pipes)
			});
		}
	}
}

function portfolio2_functions()
{
	$=jQuery;
	if($('.portfolio2').length)
	{
		if ($('.portfolio2 .custom_meta').length < 1)
		{
			$('.portfolio2 .et_pb_portfolio_item').each(function(){
				var $post_title = $(this).find('.et_pb_module_header');
				var $categories = $(this).find('.post-meta');
				$(this).find('.et_overlay').append('<div class="custom_meta"></div>');
				$(this).find('.custom_meta').append($post_title, $categories);
			});
		}
	}
}

jQuery(document).ready(function( $ ) { 

	/* Hiding and showing subpages in Mobile Menu */
    setTimeout(function() 
    {
        $('#mobile_menu .menu-item-has-children > a').off('click');
        $('#mobile_menu .menu-item-has-children > a').on('click', function(e){
            e.preventDefault();
        });
        $('#mobile_menu .sub-menu').addClass('hide_submenu');
        $('#mobile_menu li.menu-item-has-children > a').addClass('submenu_hidden');
        $('#mobile_menu .sub-menu').each(function()
        {
            $(this).parent().on('click', function(event)
            {
                $(this).find('.sub-menu').toggleClass('hide_submenu');
                $(this).find('a:first-child').toggleClass('submenu_hidden');
            });
        });
    }, 100);

	replaceSVG('svg_icon');

	/* Pricing2 Apply Featured Table Background Color to Border Color */
	if ($('.pricing2').length)
	{
		$('.pricing2').each(function(){
			var $pricing2_featured_background_color = $(this).find('.et_pb_featured_table').css('background-color');
			$(this).find('.et_pb_featured_table').css('border-color', $pricing2_featured_background_color);
		});
	}

	/* CTA1 changing image and content order and applying text color to line */
	if ($('.cta1').length)
	{
		$('.cta1').each(function(){
			var $cta1_text_color = $(this).find('.et_pb_module_header').css('color');
			$(this).find('.et_pb_blurb_content').append('<div class="line"></div>');
			$(this).find('.et_pb_main_blurb_image').appendTo($(this).find('.et_pb_blurb_content'));
			$(this).find('.et_pb_blurb_content .line').css('background-color', $cta1_text_color);
		});
	}

	/* Accordion2 and Accordion3 Applying Border Color */
	if ($('.accordion2').length || $('.accordion3').length)
	{
		$('.accordion2, .accordion3').each(function(){
			var $border_color = $(this).find('.et_pb_accordion_item').css('border-bottom-color');
			$(this).find('.et_pb_accordion_item').css('border-color',$border_color);
		});
	}

	/* Blurb3 Background Color Blend Mode Transition and Making Blurb Clickable*/
	if ($('.blurb3').length)
	{
		$('.blurb3').find('.et_pb_blurb').each(function(){
			var $bckg_color = $(this).css('background-color');

			$(this).css('background-color','transparent');

			$(this).mouseenter(function() {
				$(this).css('background-color', $bckg_color);
			});
			$(this).mouseleave(function() {
				$(this).css('background-color', 'transparent');
			});
		});

	}

	/* Modal Popup for Image element with Video Link */
	if($('.video_popup').length) 
	{
        $('.video_popup').on('click', function(e){        
            e.preventDefault();
            var link = $(this).find('a').attr('href');
            $.magnificPopup.open({
                 items: {
                   src: link
                 },
                 type: 'iframe',
                 mainClass: 'mfp-fade video_popup_lightbox'
            });
        });
	}
	
	/* Team1 add Learn More link to Photo */
	if ($('.team1').length)
	{
		$('.team1 .et_pb_column').each(function(){
			if ($(this).find('.et_pb_image a').length)
			{
				$(this).find('.et_pb_image .et_pb_image_wrap').append('<span class="learn_more">Learn More</a>');
			}
		});
	}

	/* Blog1 rearranging elements */
	blog1_functions();

	/* Blog2 rearranging elements and making sure Post Meta styles are applyed to custom_meta */
	blog2_functions();

	/* Blog3 rearranging elements */
	blog3_functions();

	/* Portfolio rearranging elements */
	portfolio2_functions();

	/* Triggering Blog and Portfolio Functions when Page is changed */
	$( document ).ajaxSuccess(function(event, request, settings) 
	{
		if(settings.url.indexOf('/page/') !== -1)
		{
			blog1_functions();
			blog2_functions();
			blog3_functions();
			portfolio2_functions();
		}
	});

	/* Social Media1 Applying max-width value to width */
	if ($('.social_media1').length)
	{
		$('.social_media1').each(function(){
			var $max_width = $(this).find('.et_pb_divider').css('max-width');
			$(this).find('.et_pb_divider').css('width', $max_width);
		});
	}

});

jQuery(window).on('load', function() { 
	
	$=jQuery;

	/* Pricing1 Applying Custom Color to Featured Table Button */
	if ($('.pricing1').length)
	{
		$('.pricing1').each(function(){
			var $pricing1_button_color = $(this).find('.et_pb_button').css('color');
			$(this).append('<style>body #page-container .et_pb_column .pricing1 .et_pb_featured_table .et_pb_button_wrapper a.et_pb_pricing_table_button.et_pb_button.et_pb_custom_button_icon {background-color: '+ $pricing1_button_color +'!important; color: #fff!important;} body #page-container .et_pb_column .pricing1 .et_pb_featured_table .et_pb_button_wrapper a.et_pb_pricing_table_button.et_pb_button.et_pb_custom_button_icon:hover {background-color: transparent!important; color: '+ $pricing1_button_color +'!important;}</style>');
		});
	}

	/* Pricing3 Applying Dot Color to New icon and rearranging items */
	if ($('.pricing3').length)
	{
		$('.pricing3').each(function(){
			var $dot_selector = $(this).find('.et_pb_pricing li span');
			var $pricing3_dot_color = window.getComputedStyle($dot_selector[0], ':before').getPropertyValue('border-left-color');
			var $pricing3_list_color = $(this).find('.et_pb_pricing li').css('color');
			$(this).before('<style>.pricing3 .et_pb_pricing li span:before {color: '+ $pricing3_dot_color +'!important;} .pricing3 .et_pb_pricing li.et_pb_not_available span:before {color: '+ $pricing3_list_color +'!important;}</style>');
			$(this).find('.et_pb_pricing_table').each(function(){
				$(this).prepend('<div class="pricing_table_inner"></div>');
				$(this).find('.et_pb_pricing_heading, .et_pb_pricing_content_top, .et_pb_pricing_content').appendTo($(this).find('.pricing_table_inner'));
			});
		});
	}

	/* Accordion2 Active arrow color */
	if ($('.accordion2').length)
	{
		$('.accordion2').each(function(){
			var $active_toggle_color = $(this).find('.et_pb_toggle_open .et_pb_toggle_title').css('color');
			$(this).before('<style>.accordion2.et_pb_accordion .et_pb_toggle_open .et_pb_toggle_title:before {color: '+ $active_toggle_color +'!important;}</style>');
		});
	}

	/* Tabs1 Apply Active Tab Background Color and color to Hover */
	if ($('.tabs1').length)
	{
		$('.tabs1').each(function(){
			var $active_bckgnd = $(this).find('.et_pb_tabs_controls li.et_pb_tab_active').css('background-color');
			var $active_color = $(this).find('.et_pb_tabs_controls li.et_pb_tab_active a').css('color');
			$(this).before('<style>.tabs1 .et_pb_tabs_controls li:hover {background-color: '+ $active_bckgnd +'!important;} .tabs1 .et_pb_tabs_controls li:hover a {color: '+ $active_color +'!important;}</style>');
		});
	}

	/* Tabs2 Apply Active Tab Background Color and color to Hover */
	if ($('.tabs2').length)
	{
		$('.tabs2').each(function(){
			var $active_bckgnd = $(this).find('.et_pb_tabs_controls li.et_pb_tab_active').css('background-color');
			var $active_color = $(this).find('.et_pb_tabs_controls li.et_pb_tab_active a').css('color');
			$(this).before('<style>.tabs2 .et_pb_tabs_controls li:hover {background-color: '+ $active_bckgnd +'!important;} .tabs2.et_pb_tabs .et_pb_tabs_controls li:hover a {color: '+ $active_color +'!important;}</style>');
		});
	}

	/* Tabs3 Apply Active Tab Background Color to Hover and list checkmark */
	if ($('.tabs3').length)
	{
		$('.tabs3').each(function(){
			var $active_bckgnd = $(this).find('.et_pb_tabs_controls li.et_pb_tab_active').css('background-color');
			var $active_link_color = $(this).find('.et_pb_tabs_controls li.et_pb_tab_active a').css('color');
			$(this).before('<style>.tabs3 .et_pb_tabs_controls li:hover {background-color: '+ $active_bckgnd +'!important;} .tabs3.et_pb_tabs .et_pb_tabs_controls li:hover a {color: '+ $active_link_color +'!important;} .tabs3 .et_pb_tab_content ul li:before {color: '+ $active_bckgnd +'!important;}</style>');
		});
	}

	/* Process1 Link and Hover color */
	if ($('.process1').length)
	{
		$('.process1 .et_pb_column').each(function(index, value){
			var $column_content = $(this).find('.et_pb_module');
			var $hover_color = $(this).find('.et_pb_text:last-child').css('color');
			var $column_link = $(this).find('.et_pb_image a').attr('href');
			var $column_link_target = ($(this).find('.et_pb_image a').attr('target')) ? $(this).find('.et_pb_image a').attr('target') : '_self';
			$(this).prepend('<style>.process1 .et_pb_column:nth-child('+ (index+1) +'):hover .et_pb_image_wrap svg path, .process1 .et_pb_column:nth-child('+ (index+1) +'):hover .et_pb_image_wrap svg circle {fill: '+ $hover_color +'!important;}</style>');
			if($column_link != null)
			{
				$(this).append('<a href="'+ $column_link +'" class="column_inner" target="'+ $column_link_target +'"></a>');
				$(this).find('.column_inner').append($column_content);
			}
		});
	}

	/* Process2 Link and Hover color */
	if ($('.process2').length)
	{
		$('.process2 .et_pb_column').each(function(){
			var $column_content = $(this).find('.et_pb_module');
			var $column_link = $(this).find('.et_pb_image a').attr('href');
			var $column_link_target = ($(this).find('.et_pb_image a').attr('target')) ? $(this).find('.et_pb_image a').attr('target') : '_self';
			var $image_padding = $(this).find('.et_pb_image').css('padding');
			var $column_color = $(this).find('.et_pb_text:nth-child(3)').css('color');
			$(this).prepend('<style>.process2 .et_pb_column .column_inner:after {background-color: '+ $column_color +'!important;} .process2 .et_pb_column:hover .et_pb_image_wrap {border-color: '+ $column_color +'!important;}</style>');
			$(this).find('.et_pb_image_wrap').css('padding',$image_padding);
			$(this).find('.et_pb_image').css('padding','0px');
			if($column_link != null)
			{
				$(this).append('<a href="'+ $column_link +'" class="column_inner" target="'+ $column_link_target +'"></a>');
				$(this).find('.column_inner').append($column_content);
			}
		});
	}

	/* Process3 Link and Hover color */
	if ($('.process3').length)
	{
		$('.process3 .et_pb_column').each(function(index, value){
			var $column_content = $(this).find('.et_pb_module');
			var $column_link = $(this).find('.et_pb_button').attr('href');
			var $column_link_target = ($(this).find('.et_pb_button').attr('target')) ? $(this).find('.et_pb_button').attr('target') : '_self';
			var $hover_color = $(this).find('.et_pb_text:first-child h3').css('color');
			$(this).prepend('<style>.process3 .et_pb_column:nth-child('+ (index+1) +') .et_pb_text:first-child h3:before {border-color: '+ $hover_color +'!important;} .process3 .et_pb_column:nth-child('+ (index+1) +'):hover .et_pb_text:first-child h3:before {background-color: '+ $hover_color +'!important; color: #fff;}</style>');
			if($column_link != null)
			{
				$(this).append('<a href="'+ $column_link +'" class="column_inner" target="'+ $column_link_target +'"></a>');
				$(this).find('.column_inner').append($column_content);
			}
		});
	}
	
});