<?php if( file_exists( get_stylesheet_directory().'/jedi-apprentice/jedi-apprentice-import.php' ) && !defined('JEDI_APPRENTICE_PATH') ) {include_once( get_stylesheet_directory().'/jedi-apprentice/jedi-apprentice-import.php' );} ?><?php


global $kaydenVersion;
$kaydenVersion = '1.2.2';

//======================================================================
// API LICENSING
//======================================================================

if ( ! class_exists( 'KAYDEN_1_1' ) ) {
	require_once( get_stylesheet_directory() . '/wc-am-client.php' );
}

if ( class_exists( 'KAYDEN_1_1' ) ) {
	/**
	 *
	 * @param string $file             Must be __FILE__ from the root plugin file, or theme functions, file locations.
	 * @param int    $product_id       Must match the Product ID number (integer) in the product.
	 * @param string $software_version This product's current software version.
	 * @param string $plugin_or_theme  'plugin' or 'theme'
	 * @param string $api_url          The URL to the site that is running the API Manager. Example: https://www.toddlahman.com/
	 * @param string $software_title   The name, or title, of the product. The title is not sent to the API Manager APIs, but is used for menu titles.
	 *
	 */

	$kaydenVersion = new KAYDEN_1_1( __FILE__, 227427, $kaydenVersion, 'theme', 'https://besuperfly.com/', 'Kayden' );
}
    
//======================================================================
// ENQUEUE STYLESHEET and JAVASCRIPT
//======================================================================

function kayden_enqueue_assets() 
{
    wp_enqueue_style( 'parent-style', get_template_directory_uri().'/style.css' );
    wp_enqueue_script( 'custom-scripts', get_stylesheet_directory_uri().'/custom-scripts.js', array('jquery'), date("h.i.s"), true );
}
add_action( 'wp_enqueue_scripts', 'kayden_enqueue_assets' );

//======================================================================
// ADDING CUSTOM FOOTER TO SITE PAGES IN DIVI 3.1 and HIGHER
//======================================================================

add_action('et_after_main_content','kayden_get_divi_global_section');

//======================================================================
// Add SVG Support to Media Library
//======================================================================

function kayden_mime_types($mimes) 
{
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'kayden_mime_types');

//======================================================================
// SHOW MENU BY ID SHORTCODE
//======================================================================

function kayden_menu_shortcode_func( $atts ) 
{
	$atts = shortcode_atts( array(
		'menu_id' => '',
		'css_class' => '',
	), $atts, 'kayden_menu' );

	//
	if($atts["menu_id"]!="")
	{
		$add_css="";
		return wp_nav_menu( array('menu'=>$atts["menu_id"], 'container_id'=>'kayden_menu_'.str_replace(' ', '_', $atts["menu_id"]), 'container_class'=>'kayden_menu '.$atts["css_class"], 'echo'=>false, 'items_wrap'=> '<ul id="%1$s" class="%2$s">%3$s</ul>') );
	}
	else return "";
}
add_shortcode( 'kayden_menu', 'kayden_menu_shortcode_func' );

//======================================================================
// LOAD A GLOBAL DIVI SECTION SELECTED BY TITLE SHORTCODE
//======================================================================

function kayden_get_divi_global_section($container=false,$title="Footer")
{
	if($title!="")
	{
		if ($title=="Footer" && is_page_template("page-template-blank.php")) {
			return;
		}

		$post_tmp=get_page_by_title($title, OBJECT, 'et_pb_layout');
		if($post_tmp!=NULL)
		{
			if($container!=false){ echo '<div class="et_pb_section et_pb_with_background et_section_regular clearfix" style="margin: 0px;padding: 0px; width: 100%; max-width: none;"><div class=" et_pb_row et_pb_gutters3 clearfix" style="margin: 0px;padding: 0px; width: 100%;max-width: none;">'; }
			echo do_shortcode($post_tmp->post_content);
			if($container!=false){ echo '</div></div>'; }
		}
	}
}

//======================================================================
// CHANGE THUMBNAIL SIZE FOR BLOG MODULE
//======================================================================

add_image_size('kayden-new-blog-module-thumb', 1080, 675, true);

function kayden_new_gallery_size_w($width) {
	return 1080;
}

function kayden_new_gallery_size_h($height) {
	return 675;
}

add_filter( 'et_pb_blog_image_height', 'kayden_new_gallery_size_h' );
add_filter( 'et_pb_blog_image_width', 'kayden_new_gallery_size_w' );

//======================================================================
// CHANGE THUMBNAIL SIZE FOR Portfolio MODULE
//======================================================================

add_image_size('kayden-new-portfolio-module-thumb', 1080, 675, true);

function kayden_new_portfolio_size_w($width) {
	return 1080;
}

function kayden_new_portfolio_size_h($height) {
	return 675;
}

add_filter( 'et_pb_portfolio_image_height', 'kayden_new_portfolio_size_h' );
add_filter( 'et_pb_portfolio_image_width', 'kayden_new_portfolio_size_w' );